@extends('auth.layouts.master')

@section('title', __('Reset 2FA'))

@section('content')
<div class="card card-bordered">
    <div class="card-inner card-inner-lg">
        <div class="nk-block-head text-center">
            <h4 class="nk-block-title">{{ __('Reset 2FA Authentication') }}</h4>
        </div>
        <div class="nk-block-content text-center">
            @include('auth.partials.error', ['class' => 'text-left'])

            <p>{!! __('Enter password and confirm to reset your 2FA authentication :mail', ['mail' => '<strong>'. $email .'</strong>' ]) !!}</p>

            <form action="{{ route('auth.2fa.reset') }}" method="POST" class="form-validate is-alter">
                <div class="form-group">
                    <div class="form-control-wrap">
                        @csrf
                        <input type="hidden" name="email" value="{{ $email }}">
                        <div class="form-group">
                            <div class="form-label-group">
                                <label class="form-label" for="password">{{ __('Passcode') }} <span class="text-danger"> &nbsp;*</span></label>
                            </div>
                            <div class="form-control-wrap">
                                <a href="#" class="form-icon form-icon-right passcode-switch" data-target="password">
                                    <em class="passcode-icon icon-show icon ni ni-eye"></em>
                                    <em class="passcode-icon icon-hide icon ni ni-eye-off"></em>
                                </a>
                                <input type="password" name="password" class="form-control form-control-lg" id="password" placeholder="{{ __('Enter your passcode') }}" minlength="6" data-msg-required="{{ __('Required.') }}" data-msg-minlength="{{ __('At least :num chars.', ['num' => 6]) }}" required>
                                @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group mt-n1 mb-n2">
                    <ul class="btn-group-vertical align-center">
                        <li class="w-100">
                            <button id="btnconfirm" class="btn btn-lg btn-block btn-primary">{{ __('Confirm')}}</button>
                        </li>
                    </ul>
                    <div class="text-center mt-4">
                        <a class="link link-btn" href="{{ route('welcome') }}">{{ __("Return to Home") }}</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
