<?php

namespace App\Http\Requests\User\Transaction;

use Illuminate\Foundation\Http\FormRequest;

class WithdrawPreviewRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'wd_account' => ['required'],
            'wd_currency' => ['required'],
            'wd_currency_to' => ['required'],
            'wd_amount' => ['required', 'numeric'],
            'wd_desc' => ['nullable'],
            'wd_amount_to' => ['required', 'numeric'],
            'wd_amount_by' => ['nullable'],
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'wd_account.required' => __('Select the account you would like to withdraw.'),
            'wd_currency.required' => __('Enter your currency to withdraw.'),
            'wd_amount.*' => __('Enter a valid amount in withdraw amount.'),
            'wd_amount_to.*' => __('Enter a valid amount in amount to receive.'),
        ];
    }
}
