<?php


namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\UserActivity;
use App\Services\ActivityLogger;

class ActivityController extends Controller
{
    private $logger;

    public function __construct(ActivityLogger $logger)
    {
        $this->logger = $logger;
    }

    /**
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\View\View
     * @version 1.0.0
     * @since 1.0
     */
    public function view()
    {
        $activities = $this->logger->view();
        return view('user.account.activity', compact('activities'));
    }

    /**
     * @param $id
     * @return \Illuminate\Http\RedirectResponse
     * @version 1.0.0
     * @since 1.0
     */
    public function destroy($id)
    {
        UserActivity::where('id', $id)->where('user_id', auth()->user()->id)->delete();
        return redirect()->route('account.activity');
    }

    /**
     * @return \Illuminate\Http\RedirectResponse
     * @version 1.0.1
     * @since 1.0
     */
    public function clearActivity()
    {
        try {
            $this->logger->clearActivity();
        } catch (\Throwable $th) {
            save_error_log($th);
        }

        return redirect()->route('account.activity');
    }
}
